﻿#include <LPC407x_8x_177x_8x.h>
#include <platform.h>
#include <gpio.h>


void gpio_toggle(Pin pin) {
	
	LPC_GPIO_TypeDef* p = GET_GPIO_PORT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);	
	short state = gpio_get(pin);
	if (state == 1){p->CLR |=  (1u << pin_index);}
	else{p->SET |=  (1u << pin_index);}

}

void gpio_set(Pin pin, int value) {
	
	LPC_GPIO_TypeDef* p = GET_GPIO_PORT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
		if (value == 1){p->SET |=  (1u << pin_index);}
		else {p->CLR |=  (1u << pin_index);}
		
}

int gpio_get(Pin pin) {
	
	LPC_GPIO_TypeDef* p = GET_GPIO_PORT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
	return (p->PIN >> pin_index) & 0x1;

}




void gpio_set_mode(Pin pin, PinMode mode) {
	
	LPC_GPIO_TypeDef* p = GET_GPIO_PORT(pin);
	uint32_t pin_index = GET_PIN_INDEX(pin);
	uint32_t* pIOCON = GET_IOCON(pin);
	LPC_SC->PCONP |= (1 << 15);  //Power/clock control gpio pheriperals
	
	switch(mode) {
		case Reset:
			break;
		case Input:
			p->DIR &= ~(1 << pin_index); // Set as input.
			*pIOCON &= ~(3UL << 0 ); // Function 0 = GPIO
			break;
		case Output:
			p->DIR |= (1 << pin_index); // Set as output.
			*pIOCON &= ~(3UL << 0 ); // Function 0 = GPIO
			gpio_set(pin,LED_OFF);// Default Value 

			break;
		case PullUp:
			*pIOCON &= ~(3UL << 0 ); // Function 0 = GPIO
			*pIOCON |= (1UL << 4 ); // Enable pull-up resistor.
		  *pIOCON &= ~(1UL << 3 ); 
			gpio_set(pin, 1);
			break;
		case PullDown:
			*pIOCON &= ~(3UL << 0 ); // Function 0 = GPIO
			*pIOCON |= (1UL << 3 ); // Enable pull-down resistor.
		  *pIOCON &= ~(1UL << 4 ); 
			gpio_set(pin, 0);
			break;
	}

}



// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************   
